#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=63901 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42009, 'User Successfully Logged In [User Id: 83, Is Staff Member: No, IP: 161.0.156.111]', '2024-07-22 13:57:01', 'Brinsley Smith');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42082, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-22 16:19:12', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:54:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:54:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:54:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42104, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-22 17:02:31', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:42:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:42:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:42:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:05:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:05:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:05:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42321, 'Database Backup [database_backup_2024-07-23-00-00-03-v3-1-1.zip]', '2024-07-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:14:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:14:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:14:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42535, 'User Successfully Logged In [User Id: 2, Is Staff Member: No, IP: 207.195.86.22]', '2024-07-23 07:04:46', 'Al Jones ');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42683, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-23 11:55:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42690, 'Failed Login Attempt [Email: livinglovelly@gmail.com, Is Staff Member: No, IP: 181.118.42.96]', '2024-07-23 12:10:15', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42958, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Task Deadline Reminder - Sent to Assigned Members]', '2024-07-23 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42959, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-07-23 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43053, 'Database Backup [database_backup_2024-07-24-00-00-05-v3-1-1.zip]', '2024-07-24 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43450, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-24 13:07:36', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43457, 'User Successfully Logged In [User Id: 2, Is Staff Member: No, IP: 2604:3d09:e072:b700:f8a0:825:6a3d:9de5]', '2024-07-24 13:18:37', 'Al Jones ');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43467, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.134]', '2024-07-24 13:32:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43471, 'New Payment Mode Added [ID: 4, Name:Manual Paypal Payment]', '2024-07-24 13:41:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43472, 'Payment Recorded [ID:105, Invoice Number: INV-133/05/2024, Total: $2,800.00]', '2024-07-24 13:44:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43476, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-07-24 13:44:09', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43477, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-07-24 13:44:12', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43610, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-24 18:09:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43695, 'Invoice Status Updated [Invoice Number: INV-156/07/2024, From: Unpaid To: Overdue]', '2024-07-24 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43696, 'Email Sent To [Email: lessons1on1@gmail.com, Template: Invoice Overdue Notice]', '2024-07-24 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43790, 'Database Backup [database_backup_2024-07-25-00-00-06-v3-1-1.zip]', '2024-07-25 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44226, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-25 14:33:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44233, 'Invoice Status Updated [Invoice Number: INV-160/07/2024, From: Unpaid To: Paid]', '2024-07-25 14:44:31', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44234, 'Payment Recorded [ID:106, Invoice Number: INV-160/07/2024, Total: $1,500.00]', '2024-07-25 14:44:31', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44235, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-07-25 14:44:40', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-25 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44518, 'Database Backup [database_backup_2024-07-26-00-00-04-v3-1-1.zip]', '2024-07-26 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44732, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-26 07:08:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (44999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45006, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-26 16:11:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45151, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-07-26 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45152, 'Invoice Status Updated [Invoice Number: INV-157/07/2024, From: Unpaid To: Overdue]', '2024-07-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-26 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-26 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-26 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45246, 'Database Backup [database_backup_2024-07-27-00-02-02-v3-1-1.zip]', '2024-07-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45568, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-27 10:44:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45875, 'Email Sent To [Email: lessons1on1@gmail.com, Template: Invoice Overdue Notice]', '2024-07-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-27 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-27 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-27 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45969, 'Database Backup [database_backup_2024-07-28-00-00-04-v3-1-1.zip]', '2024-07-28 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (45999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-28 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-28 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-28 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (46174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com