#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=299647 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 07:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275544, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-11 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275647, 'Database Backup [database_backup_2025-05-12-00-04-03-v3-1-6.zip]', '2025-05-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (275999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276215, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:d62:d979:8b6b:7f65]', '2025-05-12 15:52:53', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276216, 'Non Existing User Tried to Login [Email: saylesstt@gmail.com, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:d62:d979:8b6b:7f65]', '2025-05-12 15:53:05', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276217, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-05-12 15:53:38', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276218, 'Invoice Status Updated [Invoice Number: INV-168/12/2024, From: Overdue To: Paid]', '2025-05-12 15:54:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276219, 'Payment Recorded [ID:125, Invoice Number: INV-168/12/2024, Total: $1,449.00]', '2025-05-12 15:54:28', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276220, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-05-12 15:54:35', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:17:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-12 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-12 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-12 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276488, 'Database Backup [database_backup_2025-05-13-00-00-04-v3-1-6.zip]', '2025-05-13 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (276999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 18:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277194, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-13 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277195, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Due Notice]', '2025-05-13 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277196, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Due Notice]', '2025-05-13 21:04:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:04:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:04:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:04:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-13 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277299, 'Database Backup [database_backup_2025-05-14-00-04-04-v3-1-6.zip]', '2025-05-14 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277993, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-14 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (277999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-14 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-14 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-14 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278096, 'Database Backup [database_backup_2025-05-15-00-02-03-v3-1-6.zip]', '2025-05-15 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 05:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278796, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Due Notice]', '2025-05-15 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-15 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-15 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-15 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278899, 'Database Backup [database_backup_2025-05-16-00-02-03-v3-1-6.zip]', '2025-05-16 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (278999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-16 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-16 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-16 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279424, 'Failed to connect to IMAP auto importing tickets for departmen