#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=81054 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57478, 'User Successfully Logged In [User Id: 83, Is Staff Member: No, IP: 181.118.49.236]', '2024-08-12 17:49:04', 'Brinsley Smith');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-12 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57668, 'Database Backup [database_backup_2024-08-13-00-02-05-v3-1-6.zip]', '2024-08-13 00:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (57999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58203, 'Email Sent To [Email: claireclottey@gmail.com, Template: Forgot Password]', '2024-08-13 17:47:26', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58204, 'Password Reset Email sent [Email: claireclottey@gmail.com, Is Staff Member: No, IP: 71.38.115.77]', '2024-08-13 17:47:26', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58205, 'Failed Login Attempt [Email: claireclottey@gmail.com, Is Staff Member: No, IP: 71.38.115.77]', '2024-08-13 17:49:54', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58206, 'User Successfully Logged In [User Id: 88, Is Staff Member: No, IP: 71.38.115.77]', '2024-08-13 17:50:37', 'Claire Clottey');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58237, 'Failed Login Attempt [Email: claireclottey@gmail.com, Is Staff Member: No, IP: 71.38.115.77]', '2024-08-13 18:49:48', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58304, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-13 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-13 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-13 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-13 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58398, 'Database Backup [database_backup_2024-08-14-00-02-03-v3-1-6.zip]', '2024-08-14 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58471, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-14 02:30:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 14:55:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (58999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-14 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59135, 'Database Backup [database_backup_2024-08-15-00-00-05-v3-1-6.zip]', '2024-08-15 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59616, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-15 15:57:36', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59617, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.161]', '2024-08-15 15:57:36', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-15 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-15 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-15 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59861, 'Database Backup [database_backup_2024-08-16-00-00-05-v3-1-6.zip]', '2024-08-16 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (59999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60492, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-16 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-16 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-16 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-16 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60586, 'Database Backup [database_backup_2024-08-17-00-02-02-v3-1-6.zip]', '2024-08-17 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (60999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61232, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.165]', '2024-08-17 21:03:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61233, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.165]', '2024-08-17 21:03:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61324, 'Database Backup [database_backup_2024-08-18-00-00-04-v3-1-6.zip]', '2024-08-18 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-18 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (61526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `da