#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=71277 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48316, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-07-31 05:43:22', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48350, 'Non Existing User Tried to Login [Email: bdallasferdinand@outlook.com, Is Staff Member: No, IP: 200.7.90.167]', '2024-07-31 06:57:38', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48357, 'whiteboard Group Added [ID: 1]', '2024-07-31 07:09:40', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48361, 'New Web to Lead Form Added [Test]', '2024-07-31 07:14:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48362, 'Email sent to: clientportal@saylesstt.com Subject: Mentioned you', '2024-07-31 07:15:46', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48369, 'Mindmap Group Added [ID: 1]', '2024-07-31 07:25:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48370, 'Mindmap Deleted [ID:1]', '2024-07-31 07:25:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48371, 'Group Deleted [1]', '2024-07-31 07:25:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48372, 'Mindmap Group Added [ID: 2]', '2024-07-31 07:25:35', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48379, 'New Landing Page added [ID:1]', '2024-07-31 07:33:48', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48380, 'Staff Status Changed [StaffID: 7 - Status(Active/Inactive): 0]', '2024-07-31 07:35:10', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48390, 'New Feedback Added [ID: 1, Subject: Feedback]', '2024-07-31 07:52:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48664, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-07-31 16:56:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48665, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-07-31 16:56:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-31 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48879, 'Database Backup [database_backup_2024-08-01-00-00-04-v3-1-6.zip]', '2024-08-01 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (48999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49180, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-08-01 10:03:49', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49181, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-08-01 10:03:49', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49320, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-08-01 14:36:44', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49513, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-01 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49529, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-08-01 21:26:21', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49530, 'Invoice Status Updated [Invoice Number: INV-156/07/2024, From: Overdue To: Paid]', '2024-08-01 21:27:54', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49531, 'Payment Recorded [ID:107, Invoice Number: INV-156/07/2024, Total: $230.00]', '2024-08-01 21:27:55', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49532, 'Email Sent To [Email: lessons1on1@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-01 21:28:03', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49575, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.167]', '2024-08-01 22:50:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-01 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49615, 'Database Backup [database_backup_2024-08-02-00-04-02-v3-1-6.zip]', '2024-08-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49670, 'Email sent to: tishara.f@saylesstt.com Subject: Mentioned you', '2024-08-02 01:55:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49683, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-02 02:17:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49684, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-02 02:17:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (49999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-02 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-02 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-02 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50339, 'Database Backup [database_backup_2024-08-03-00-00-04-v3-1-6.zip]', '2024-08-03 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (50999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-03 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-03 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-03 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51066, 'Database Backup [database_backup_2024-08-04-00-00-04-v3-1-6.zip]', '2024-08-04 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51697, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-04 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51791, 'Database Backup [database_backup_2024-08-05-00-02-02-v3-1-6.zip]', '2024-08-05 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 02:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (51999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52338, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.63]', '2024-08-05 18:03:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52366, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.63]', '2024-08-05 18:59:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52412, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.63]', '2024-08-05 20:27:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52422, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 20:44:06', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52423, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 20:44:06', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52424, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 20:44:12', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52425, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 20:44:13', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52429, 'User Successfully Logged In [User Id: 2, Is Staff Member: No, IP: 2604:3d09:e072:b700:44f3:1133:dd99:7c0e]', '2024-08-05 20:49:50', 'Al Jones ');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52430, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Comment on Task (Sent to Staff)]', '2024-08-05 20:50:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52431, 'Email Sent To [Email: livinglovelly@gmail.com, Template: New Comment on Task (Sent to Customer Contacts)]', '2024-08-05 20:50:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52432, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 20:50:55', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52433, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 20:50:55', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52434, 'Project Updated [ID: 25]', '2024-08-05 20:53:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52438, 'Project Updated [ID: 24]', '2024-08-05 20:55:57', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52439, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 20:59:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52440, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 20:59:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52441, 'New Task Added [ID:232, Name: First draft]', '2024-08-05 20:59:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52445, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:00:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52446, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:00:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52447, 'New Task Added [ID:233, Name: second draft]', '2024-08-05 21:00:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52448, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52449, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52450, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52451, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52452, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:00:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52453, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:01:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52454, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:01:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52455, 'New Task Added [ID:234, Name: Third draft]', '2024-08-05 21:01:23', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52456, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52457, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52458, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52459, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52460, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:02:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52461, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:03:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52462, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:03:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52463, 'New Task Added [ID:235, Name: Reviews draft]', '2024-08-05 21:03:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52464, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:03:26', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52465, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:03:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52466, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:03:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52467, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:03:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52468, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:03:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52469, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:04:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52470, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:04:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52471, 'New Task Added [ID:236, Name: Final draft (website complete)]', '2024-08-05 21:04:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52472, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52473, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52474, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52475, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52476, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:04:29', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52477, 'Task Updated [ID:233, Name: Second draft]', '2024-08-05 21:04:51', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52481, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-08-05 21:08:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52482, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-08-05 21:08:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52483, 'New Task Added [ID:237, Name: Hand over]', '2024-08-05 21:08:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52484, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-08-05 21:08:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52485, 'Email Sent To [Email: keripatrick@me.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:08:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52486, 'Email Sent To [Email: claireclottey@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:08:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52487, 'Email Sent To [Email: candice.imam@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:08:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52488, 'Email Sent To [Email: chersmm868@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-08-05 21:08:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52492, 'User Successfully Logged In [User Id: 88, Is Staff Member: No, IP: 2607:fb90:73aa:442e:bda4:1704:42c:3318]', '2024-08-05 21:13:40', 'Claire Clottey');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-05 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-05 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-05 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52580, 'Database Backup [database_backup_2024-08-06-00-01-03-v3-1-6.zip]', '2024-08-06 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (52725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-06 04:44:02', '[CRON]');
INSERT