#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=186310 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (161999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-22 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162402, 'Database Backup [database_backup_2024-12-23-00-03-03-v3-1-6.zip]', '2024-12-23 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 02:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 05:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (162999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163087, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-23 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163088, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-23 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163194, 'Database Backup [database_backup_2024-12-24-00-01-03-v3-1-6.zip]', '2024-12-24 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163324, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.3]', '2024-12-24 04:02:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-24 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163979, 'Database Backup [database_backup_2024-12-25-00-04-02-v3-1-6.zip]', '2024-12-25 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (163999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 13:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164766, 'Database Backup [database_backup_2024-12-26-00-04-02-v3-1-6.zip]', '2024-12-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (164999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165088, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.166]', '2024-12-26 09:55:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165110, 'Invoice Status Updated [Invoice Number: INV-169/11/2024, From: Unpaid To: Overdue]', '2024-12-26 10:29:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165111, 'Invoice Status Updated [Invoice Number: INV-169/11/2024, From: Overdue To: Unpaid]', '2024-12-26 10:30:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165466, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-26 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165467, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-26 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165567, 'Database Backup [database_backup_2024-12-27-00-02-02-v3-1-6.zip]', '2024-12-27 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (165999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-27 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (166189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-27 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`