#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=90061 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (64999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-23 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65484, 'Database Backup [database_backup_2024-08-24-00-01-02-v3-1-6.zip]', '2024-08-24 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65581, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 181.118.42.54]', '2024-08-24 02:50:31', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65585, 'Invoice Status Updated [Invoice Number: INV-159/07/2024, From: Unpaid To: Partially Paid]', '2024-08-24 02:51:40', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65586, 'Payment Recorded [ID:111, Invoice Number: INV-159/07/2024, Total: $750.00]', '2024-08-24 02:51:40', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65587, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-08-24 02:51:44', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (65999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-24 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-24 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-24 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66293, 'Database Backup [database_backup_2024-08-25-00-01-02-v3-1-6.zip]', '2024-08-25 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 00:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 00:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 00:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 03:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 03:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 03:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66975, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-08-25 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (66999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-25 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67075, 'Database Backup [database_backup_2024-08-26-00-05-02-v3-1-6.zip]', '2024-08-26 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 03:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 03:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 03:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 15:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 17:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-26 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67868, 'Database Backup [database_backup_2024-08-27-00-04-02-v3-1-6.zip]', '2024-08-27 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (67999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 09:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68430, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.154]', '2024-08-27 16:57:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68437, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 622]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68438, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 621]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68439, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 620]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68440, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 619]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68441, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 618]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68442, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 617]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68443, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 616]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68444, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 615]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68445, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 614]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68446, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 613]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68447, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 612]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68448, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 611]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68449, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 610]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68450, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 609]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68451, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 608]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68452, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 607]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68453, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 606]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68454, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 605]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68455, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 604]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68456, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 603]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68457, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 602]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68458, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 601]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68459, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 600]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68460, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 599]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68461, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 598]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68462, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 597]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68463, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 596]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68464, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 595]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68465, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 594]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68466, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 593]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68467, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 592]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68468, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 591]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68469, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 590]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68470, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 589]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68471, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 588]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68472, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 587]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68473, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 586]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68474, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 585]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68475, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 584]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68476, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 583]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68477, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 582]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68478, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 581]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68479, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 580]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68480, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 579]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68481, 'Proposal Deleted [ProposalID:7]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68482, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 578]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68483, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 577]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68484, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 576]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68485, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 575]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68486, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 574]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68487, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 573]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68488, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 572]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68489, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 571]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68490, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 570]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68491, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 569]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68492, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 568]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68493, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 567]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68494, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 566]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68495, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 565]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68496, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 564]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68497, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 563]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68498, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 562]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68499, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 561]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68500, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 560]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68501, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 559]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68502, 'Lead Attachment Deleted [ID: 559]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68503, 'Proposal Deleted [ProposalID:6]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68504, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 558]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68505, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 557]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68506, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 556]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68507, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 555]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68508, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 554]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68509, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 553]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68510, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 552]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68511, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 551]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68512, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 550]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68513, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 549]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68514, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 548]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68515, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 547]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68516, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 546]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68517, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 545]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68518, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 544]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68519, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 543]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68520, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 542]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68521, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 541]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68522, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 540]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68523, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 539]', '2024-08-27 17:10:20', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68524, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 538]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68525, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 537]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68526, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 536]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68527, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 535]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68528, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 534]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68529, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 532]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68530, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 531]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68531, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 530]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68532, 'Proposal Deleted [ProposalID:3]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68533, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 529]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68534, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 528]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68535, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 527]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68536, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 526]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68537, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 525]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68538, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 524]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68539, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 523]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68540, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 522]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68541, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 521]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68542, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 520]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68543, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 519]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68544, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 518]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68545, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 517]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68546, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 516]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68547, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 515]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68548, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 514]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68549, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 513]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68550, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 512]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68551, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 511]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68552, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 510]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68553, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 509]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68554, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 508]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68555, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 507]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68556, 'Proposal Deleted [ProposalID:2]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68557, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 506]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68558, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 505]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68559, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 504]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68560, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 503]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68561, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 500]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68562, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 498]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68563, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 497]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68564, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 496]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68565, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 495]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68566, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 494]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68567, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 493]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68568, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 492]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68569, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 490]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68570, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 489]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68571, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 488]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68572, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 487]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68573, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 486]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68574, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 485]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68575, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 484]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68576, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 483]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68577, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 482]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68578, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 481]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68579, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 480]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68580, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 479]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68581, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 476]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68582, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 475]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68583, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 474]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68584, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 473]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68585, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 472]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68586, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 471]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68587, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 470]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68588, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 469]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68589, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 468]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68590, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 467]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68591, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 466]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68592, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 465]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68593, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 464]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68594, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 463]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68595, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 462]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68596, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 461]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68597, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 460]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68598, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 459]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68599, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 458]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68600, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 457]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68601, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 456]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68602, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 455]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68603, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 454]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68604, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 453]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68605, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 452]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68606, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 76]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68607, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 41]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68608, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 26]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68609, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 25]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68610, 'Lead Deleted [Deleted by: Dallas Ferdinand, ID: 24]', '2024-08-27 17:10:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 21:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 21:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 21:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-27 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-27 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-27 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68839, 'Database Backup [database_backup_2024-08-28-00-03-03-v3-1-6.zip]', '2024-08-28 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (68999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 11:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (69316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-08-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `