#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=152122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 17:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (128999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:31:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-10 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129129, 'Database Backup [database_backup_2024-11-11-00-01-03-v3-1-6.zip]', '2024-11-11 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 18:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129820, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-11 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129821, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-11 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:04:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-11 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-11 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-11 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129921, 'Database Backup [database_backup_2024-11-12-00-00-04-v3-1-6.zip]', '2024-11-12 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (129999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130270, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.172]', '2024-11-12 10:28:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-12 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-12 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-12 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130724, 'Database Backup [database_backup_2024-11-13-00-05-02-v3-1-6.zip]', '2024-11-13 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (130999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-13 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-13 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-13 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131523, 'Database Backup [database_backup_2024-11-14-00-02-02-v3-1-6.zip]', '2024-11-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131620, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.177]', '2024-11-14 02:58:47', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 12:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 12:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 12:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (131999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132224, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-14 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132225, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-14 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-14 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132331, 'Database Backup [database_backup_2024-11-15-00-05-02-v3-1-6.zip]', '2024-11-15 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-15 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-15 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (132904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-15 17:36:02', '[CRON]');
INSERT INTO `tblactivi