#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=375053 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 12:59:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 12:59:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 12:59:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (359999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-06 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-06 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-06 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360200, 'Database Backup [database_backup_2025-09-07-00-00-04-v3-3-1.zip]', '2025-09-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 14:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360849, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360850, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360851, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360852, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360853, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-07 21:04:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360854, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360855, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360856, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-07 21:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:04:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-07 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-07 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-07 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360950, 'Database Backup [database_backup_2025-09-08-00-01-03-v3-3-1.zip]', '2025-09-08 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (360999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 05:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-08 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-08 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-08 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361680, 'Database Backup [database_backup_2025-09-09-00-04-02-v3-3-1.zip]', '2025-09-09 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (361999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362014, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8f6:a4c3:2df2:c352:90e9]', '2025-09-09 11:03:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362015, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8f6:a4c3:2df2:c352:90e9]', '2025-09-09 11:03:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362421, 'Database Backup [database_backup_2025-09-10-00-00-02-v3-3-1.zip]', '2025-09-10 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362989, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8f6:5440:64a8:7680:843]', '2025-09-10 18:24:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (362999, 'Invoice Status Updated [Invoice Number: INV-186/08/2025, From: Overdue To: Paid]', '2025-09-10 18:38:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363000, 'Payment Recorded [ID:138, Invoice Number: INV-186/08/2025, Total: $500.00]', '2025-09-10 18:38:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363001, 'Copied Invoice INV-186/08/2025', '2025-09-10 18:39:10', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363002, 'Invoice Status Updated [Invoice Number: INV-189/09/2025, From: Draft To: Unpaid]', '2025-09-10 18:39:45', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363057, 'Non Existing User Tried to Login [Email: admin@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8f6:31be:4bbd:4a1d:1579]', '2025-09-10 20:22:11', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363058, 'Non Existing User Tried to Login [Email: admin@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8f6:31be:4bbd:4a1d:1579]', '2025-09-10 20:22:21', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363059, 'Non Existing User Tried to Login [Email: admin@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8f6:31be:4bbd:4a1d:1579]', '2025-09-10 20:22:39', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363078, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363079, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-10 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363080, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363081, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-10 21:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363082, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-10 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-10 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363179, 'Database Backup [database_backup_2025-09-11-00-03-01-v3-3-1.zip]', '2025-09-11 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 10:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-11 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363930, 'Database Backup [database_backup_2025-09-12-00-05-02-v3-3-1.zip]', '2025-09-12 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (363999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:00:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:00:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:00:38', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-12 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-12 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-12 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (364236, 'Failed to connect to IMAP auto importing tickets for department developme