#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=236376 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (213999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214280, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-25 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-25 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214383, 'Database Backup [database_backup_2025-02-26-00-04-03-v3-1-6.zip]', '2025-02-26 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (214999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-26 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-26 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-26 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215179, 'Database Backup [database_backup_2025-02-27-00-02-03-v3-1-6.zip]', '2025-02-27 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215876, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-27 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215877, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-27 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-27 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-27 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-27 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215986, 'Database Backup [database_backup_2025-02-28-00-03-02-v3-1-6.zip]', '2025-02-28 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (215999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216680, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-28 21:03:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:03:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:03:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:03:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-28 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-28 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-28 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216786, 'Database Backup [database_backup_2025-03-01-00-04-02-v3-1-6.zip]', '2025-03-01 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (216999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 12:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 12:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 12:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 20:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217585, 'Database Backup [database_backup_2025-03-02-00-01-03-v3-1-6.zip]', '2025-03-02 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (217999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-02 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-02 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (218157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-02 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descrip