#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=121975 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97903, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-10-02 17:45:19', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (97999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98111, 'Database Backup [database_backup_2024-10-03-00-04-01-v3-1-6.zip]', '2024-10-03 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 13:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98799, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-03 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98899, 'Database Backup [database_backup_2024-10-04-00-03-02-v3-1-6.zip]', '2024-10-04 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (98999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99224, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-10-04 10:02:01', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 22:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99687, 'Database Backup [database_backup_2024-10-05-00-00-04-v3-1-6.zip]', '2024-10-05 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 03:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (99999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-05 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-05 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-05 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100480, 'Database Backup [database_backup_2024-10-06-00-03-03-v3-1-6.zip]', '2024-10-06 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100526, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.6]', '2024-10-06 01:25:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 10:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:05:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:05:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:05:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (100999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 18:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101175, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-06 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101275, 'Database Backup [database_backup_2024-10-07-00-02-02-v3-1-6.zip]', '2024-10-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 04:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-10-07 10:34:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-07 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-07 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (101903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-07 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, 